<?php
/**
 * Misscall API
 * PHP Version 7.2
 *
 * @category MisscallAPI
 * @package  MisscallAPI
 * @author   Bimalmithran PB <bimal@moplet.com>
 * @license  http://misscallapi.moplet.com/   MisscallAPI
 * @link     http://misscallapi.moplet.com/v1
 */

error_reporting(E_ALL);
ini_set('display_errors', '1');
header('Content-Type: application/json');

ignore_user_abort(true);
set_time_limit(0);

ob_start();

$apikey = isset($_GET['apikey']) ? $_GET['apikey'] : '';
$from = isset($_GET['from']) ? $_GET['from'] : '';
$to = isset($_GET['to']) ? $_GET['to'] : '';
$ring_timeout = isset($_GET['ring_timeout']) ? $_GET['ring_timeout'] : 10;
$postString = [
    'from' => "+".trim($from),
    'to' => "+".trim($to),
    ' ring_timeout' => $ring_timeout,
    'events' => [
        [
            "action" => "hangup",
        ],
    ],
];

// echo json_encode($postString);
// die;

$url = "https://api.checkmobi.com/v1/call";
$ch = curl_init($url);
$jsonData = json_encode($postString);
// Tell cURL that we want to send a POST request.
curl_setopt($ch, CURLOPT_POST, 1);
// Attach our encoded JSON string to the POST fields.
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
// Returns the response to variable
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
// Set the content type to application/json
curl_setopt(
    $ch, CURLOPT_HTTPHEADER, [
        'Content-type: application/json',
        'Authorization: ' . $apikey,
        'Accept: application/json',
    ]
);

// Execute the request
$result = curl_exec($ch);
curl_close($ch);
echo $result;
header('Connection: close');
header('Content-Length: ' . ob_get_length());
ob_end_flush();
ob_flush();
flush();

if (session_id()) {
    session_write_close();
}
$array_results = json_decode($result);

sleep($ring_timeout);

if ($array_results->id !== null) {
    $request_id = $array_results->id;

    $url2 = "https://api.checkmobi.com/v1/call/$request_id";
    $ch2 = curl_init();
    curl_setopt($ch2, CURLOPT_URL, $url2);
    curl_setopt($ch2, CURLOPT_CUSTOMREQUEST, "DELETE");
    // curl_setopt($ch2, CURLOPT_POSTFIELDS, $json);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt(
        $ch2, CURLOPT_HTTPHEADER, [
            'Content-type: application/json',
            'Authorization: ' . $apikey,
            'Accept: application/json',
        ]
    );
    $result2 = curl_exec($ch2);
    // $result2 = json_decode($result2);
    curl_close($ch2);

    // echo $result2;
}
